/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.vecvoice;

import frc.emul.periph.IPeripheral;
import frc.emul.periph.misc.AbstractDevice;
import frc.emul.periph.vecvoice.Phonem;
import frc.emul.periph.vecvoice.Phonemes;
import frc.emul.periph.vecvoice.SpeechLine;
import frc.emul.psg.IVectrexAudio;
import frc.emul.util.Utils;
import java.awt.Component;

public class VecVoice
extends AbstractDevice
implements IPeripheral.TickHandler,
IPeripheral.WriteHandler {
    private static final boolean DEBUG_VECVOICE = false;
    public static final String NAME = "VecVoice";
    public static final String ID = "VECVOICE";
    private static final int VV_CYCLES_PER_BIT = 156;
    private static final int VV_READ_DELAY = 78;
    private final IVectrexAudio audio;
    private volatile int cyclesBeforeNextBit;
    private int phonemIdx;
    private int bitsToGo;
    private boolean vvEnabled;
    private SpeechLine speechLine;

    public VecVoice(IVectrexAudio iVectrexAudio) {
        Phonemes.loadSamples(15);
        this.speechLine = new SpeechLine();
        this.vvEnabled = true;
        this.audio = iVectrexAudio;
    }

    public String getName() {
        return NAME;
    }

    public String getID() {
        return ID;
    }

    public void plug(Component component, int n) {
        this.audio.setExtraLine(this.speechLine);
        this.setEnabled(true);
    }

    public void unplug(Component component, int n) {
        this.setEnabled(false);
        this.audio.setExtraLine(null);
    }

    public final int getButtonsState() {
        return this.isReady() ? 0 : 15;
    }

    public final void handleTick(int n) {
        this.cyclesBeforeNextBit -= n;
    }

    public void handleWrite(int n, int n2) {
        if (7 != n) {
            return;
        }
        if (this.bitsToGo > 0) {
            if (this.cyclesBeforeNextBit <= 0) {
                if (--this.bitsToGo == 0) {
                    if ((n2 & 0x40) != 0) {
                        System.err.println("Warning: VecVoice Phonem's stop bit is not 1");
                    }
                    try {
                        this.emit(Phonemes.getPhonem(this.phonemIdx));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        System.err.println("Warning: Invalid VecVoice Phonem's index " + this.phonemIdx + ", phonem discarded.");
                    }
                } else {
                    int n3 = (~n2 & 0x40) << 1;
                    this.phonemIdx = n3 | this.phonemIdx >> 1;
                    this.armReadDelay();
                }
            }
        } else if ((n2 & 0x40) != 0) {
            this.phonemIdx = 0;
            this.bitsToGo = 9;
            this.armReadDelay();
        }
    }

    public final void setEnabled(boolean bl) {
        this.vvEnabled = bl;
        if (!bl) {
            this.speechLine.clear();
        }
    }

    public final boolean isEnabled() {
        return this.vvEnabled;
    }

    public final boolean isReady() {
        return this.vvEnabled && this.speechLine.isReady();
    }

    private final void emit(Phonem phonem) {
        if (!this.isReady()) {
            int n = phonem.getIndex();
            System.err.println("*** VecVoice is not ready --> Phonem $" + Utils.hex(2, n) + " discarded");
            return;
        }
        int n = this.speechLine.getSampleRateMultiplier();
        this.speechLine.emit(phonem.getData(n), 0, phonem.getDataLength(n));
    }

    private final void armReadDelay() {
        while (78 != this.cyclesBeforeNextBit) {
            this.cyclesBeforeNextBit = 78;
        }
    }
}

